% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmat.R
\name{plotVmat.list}
\alias{plotVmat.list}
\title{A function to compute (and plot) several Vmats.}
\usage{
\method{plotVmat}{list}(
  x,
  cores = 1,
  cores_subsetting = 1,
  nrow = NULL,
  ncol = NULL,
  xlims = c(-250, 250),
  ylims = c(50, 300),
  normFun = "libdepth+nloci",
  s = 0.95,
  roll = 3,
  return_Vmat = FALSE,
  verbose = 1,
  ...
)
}
\arguments{
\item{x}{list Each element of the list should be a list containing
paired-end fragments and GRanges of interest.}

\item{cores}{Integer, number of cores to parallelize the plots}

\item{cores_subsetting}{Integer, number of threads to parallelize 
fragments subsetting}

\item{nrow}{Integer, how many rows in facet?}

\item{ncol}{Integer, how many cols in facet?}

\item{xlims}{x limits of the computed Vmat}

\item{ylims}{y limits of the computed Vmat}

\item{normFun}{character. A Vmat should be scaled either by:
\itemize{
    \item 'libdepth+nloci', e.g. the library depth and the number of 
    loci used to compute the Vmat;
    \item zscore, if relative patterns of fragment density 
    are more important than density per se;
    \item Alternatively, the Vmat can be scaled to % ('pct'), to 
    a chosen quantile ('quantile') or to the max Vmat value ('max').
}}

\item{s}{A float indicating which quantile to use if 'quantile'
normalization is chosen}

\item{roll}{integer, to use as the window to smooth the Vmat rows 
by rolling mean.}

\item{return_Vmat}{Boolean, should the function return the computed 
Vmat rather than the plot?}

\item{verbose}{Boolean}

\item{...}{additional parameters}
}
\value{
A list of Vmat ggplots
}
\description{
The plotVmat.GRanges() method computes and normalizes multiple Vmats
before passing them to plotVmat.VmatList() method.
}
\examples{
data(bam_test)
data(ce11_proms)
list_params <- list(
    'germline' = list(
        bam_test,
        ce11_proms[ce11_proms$which.tissues == 'Germline']
    ),
    'muscle' = list(
        bam_test,
        ce11_proms[ce11_proms$which.tissues == 'Muscle']
    )
)
V <- plotVmat(
    list_params,
    normFun = 'libdepth+nloci', 
    roll = 5
)
}
