% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{AUC}
\alias{AUC}
\title{area under the curve
\code{AUC} Returns area under the curve}
\usage{
AUC(time, volume)
}
\arguments{
\item{time}{A \code{vector} of time points recorded for the experiment.}

\item{volume}{First \code{vector} of volume.}
}
\value{
Returns \code{angle} and \code{slope} object.
}
\description{
area under the curve
\code{AUC} Returns area under the curve
}
\examples{
time  <- c(0, 3, 7, 11, 18, 22, 26, 30, 32, 35)
volume1<- time * tan(30*pi/180)
volume2<- time * tan(45*pi/180)
auc1 <- AUC(time, volume1)
auc2 <- AUC(time, volume2)
par(pty="s")
xylimit <- range(c(time, volume1, volume2))
plot(time, volume1, type = "b", xlim = xylimit, ylim = xylimit)
lines(time, volume2, type = "b")
abline(lm(volume1~time))
abline(lm(volume2~time))
}
