% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mRECIST.R
\name{mRECIST}
\alias{mRECIST}
\title{Computes the mRECIST}
\usage{
mRECIST(time, volume, min.time = 10, return.detail = FALSE)
}
\arguments{
\item{time}{Value of best response.}

\item{volume}{Value of best average response.}

\item{min.time}{Minimum time after which tumor volume will be considered.}

\item{return.detail}{Default \code{FALSE}. If \code{TRUE}, return all intermediate values.}
}
\value{
Returns the mRECIST.
}
\description{
\code{mRECIST} Returns the mRECIST for given volume response.
}
\examples{
time  <- c(0, 3, 7, 11, 18, 22, 26, 30, 32, 35)
volume<- c(250.8, 320.4, 402.3, 382.6, 384, 445.9, 460.2, 546.8, 554.3, 617.9)
mRECIST(time, volume, min.time=10, return.detail=FALSE)
}
