% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterfall_plot.R
\name{waterfall}
\alias{waterfall}
\title{waterfall plot
Creates waterfall plot for a given drug.}
\usage{
waterfall(
  object,
  res.measure,
  drug = NULL,
  group.by = NULL,
  summary.stat = c(";", "mean", "median"),
  tissue = NULL,
  model.id = NULL,
  model.type = NULL,
  type.color = "#cc4c02",
  legend.name = NULL,
  yname = NULL,
  title = NULL,
  sort = TRUE
)
}
\arguments{
\item{object}{The \code{XevaSet} object}

\item{res.measure}{PDX model drug response measure}

\item{drug}{Name of the drug}

\item{group.by}{Group drug response data}

\item{summary.stat}{How to summarize multiple values}

\item{tissue}{Tissue type}

\item{model.id}{Indicates which \code{model.id} to plot. Default \code{NULL} will plot all models}

\item{model.type}{Type of model, such as mutated or wild type}

\item{type.color}{A list with colors used for each type in the legend}

\item{legend.name}{Name of the legend}

\item{yname}{Name for the y-axis}

\item{title}{Title of the plot}

\item{sort}{Default \code{TRUE} will sort the data}
}
\value{
waterfall plot in ggplot2
}
\description{
waterfall plot
Creates waterfall plot for a given drug.
}
\examples{
data(brca)
waterfall(brca, drug="binimetinib", res.measure="best.avg.response_published")
## example with model.type where we color the models by TP53 mutation type
mut <- summarizeMolecularProfiles(brca,drug = "binimetinib", mDataType="mutation")
model.type <- Biobase::exprs(mut)["TP53", ]
waterfall(brca, drug="binimetinib", res.measure="best.avg.response_published",
          tissue="BRCA", model.id=names(model.type), model.type= model.type)

}
