% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_SMCs.R
\name{make_comparison_matrix}
\alias{make_comparison_matrix}
\title{Compute a similarity matrix for different strata}
\usage{
make_comparison_matrix(
  in_strata_df,
  output_path = NULL,
  in_nrect = 5,
  in_attribute = "",
  in_palette = NULL
)
}
\arguments{
\item{in_strata_df}{Numerical data frame of all strata to be compared.}

\item{output_path}{Path to directory where the results, especially the figure
produced by \code{\link[corrplot]{corrplot}} is going to be stored.}

\item{in_nrect}{Number of clusters in the clustering procedure provided by
\code{\link[corrplot]{corrplot}}}

\item{in_attribute}{Additional string for the file name where the figure
produced by \code{\link[corrplot]{corrplot}} is going to be stored.}

\item{in_palette}{Colour palette for the matrix}
}
\value{
The comparison matrix of cosine similarities.
}
\description{
Compute and plot a similarity matrix for different strata from different
stratification axes together. First, \code{\link{compare_sets}} is called on
\code{in_strata_df} with itself, yielding a distance matrix (a numerical data
frame) \code{dist_df} of the strata. The corresponding similarity matrix
\code{1-dif_df} is then passed to \code{\link[corrplot]{corrplot}}.
}
\examples{
data(sigs)
make_comparison_matrix(
 AlexCosmicValid_sig_df,in_nrect=9,
 in_palette=colorRampPalette(c("blue","green","red"))(n=100))

}
\seealso{
\code{\link{compare_SMCs}}
}
