% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignGenes.R
\name{getSignGenes}
\alias{getSignGenes}
\title{The function getSignGenes orders the genes by maximizing the
significance of the gene to differentiate the clusters and ensures
that they represent at most the variations across all possible pairs
of clusters.}
\usage{
getSignGenes(expr, clusters, method = "wilcox", verbose = FALSE)
}
\arguments{
\item{expr}{A matrix of gene expression data. Rows are cells and columns
are genes.}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{method}{the statistical test to use. Either "wilcox" for the Wilcoxon
rank sum test or "ttest" for the t-test. Default is "wilcox".}

\item{verbose}{logical, set to TRUE to activate verbose mode}
}
\description{
The function getSignGenes orders the genes by maximizing the
significance of the gene to differentiate the clusters and ensures
that they represent at most the variations across all possible pairs
of clusters.
}
\details{
The function getSignGenes orders the genes by maximizing the
significance of the gene to differentiate the clusters and ensures
that they represent at most the variations across all possible pairs
of clusters.
}
\examples{
rna_expression <- data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
    CD8B=c(2,2,3,3))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","T cell","T cell","T cell")

getSignGenes(rna_expression, clusters_id, method="wilcox", verbose=TRUE)

}
