% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDataFrame.R
\name{saveObject,DataFrame-method}
\alias{saveObject,DataFrame-method}
\alias{stageObject,DataFrame-method}
\alias{saveObject,data.frame-method}
\title{Save a DataFrame to disk}
\usage{
\S4method{saveObject}{DataFrame}(x, path, DataFrame.character.vls = NULL, ...)

\S4method{saveObject}{data.frame}(x, path, DataFrame.character.vls = NULL, ...)
}
\arguments{
\item{x}{A \link[S4Vectors]{DataFrame} or data.frame.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{DataFrame.character.vls}{Logical scalar indicating whether to save character vectors in the custom variable length string (VLS) array format.
If \code{NULL}, this is determined based on a comparison of the expected storage against a fixed length array.}

\item{...}{Additional named arguments to pass to specific methods.}
}
\value{
A named list containing the metadata for \code{x}.
\code{x} itself is written to a HDF5 file inside \code{path}.
Additional files may also be created inside \code{path} and referenced from the metadata.
}
\description{
Stage a DataFrame by saving it to a HDF5 file.
}
\details{
This method creates a \code{basic_columns.h5} file that contains columns for atomic vectors, factors, dates and date-times.
Dates and date-times are converted to character vectors and saved as such inside the file.
Factors are saved as a HDF5 group with both the codes and the levels as separate datasets.

Any non-atomic columns are saved to a \code{other_columns} subdirectory inside \code{path} via \code{\link{saveObject}},
named after its zero-based positional index within \code{x}.

If \code{\link[S4Vectors]{metadata}} or \code{\link[S4Vectors]{mcols}} are present, 
they are saved to the \code{other_annotations} and \code{column_annotations} subdirectories, respectively, via \code{\link{saveObject}}.

In the on-disk representation, no distinction is made between \link[S4Vectors]{DataFrame} and data.frame instances of \code{x}.
Calling \code{readDataFrame} will always produce a \link[S4Vectors]{DFrame} regardless of the class of \code{x}.
}
\examples{
library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])

tmp <- tempfile()
saveObject(df, tmp)
list.files(tmp, recursive=TRUE)

}
\author{
Aaron Lun
}
