% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{statistics}
\alias{statistics}
\alias{get_dstat}
\alias{big_mat_list_mean}
\alias{get_list_stats}
\title{Statistics functions for the anglemania package}
\usage{
get_dstat(corr_matrix)

big_mat_list_mean(matrix_list, weights, verbose = TRUE)

get_list_stats(matrix_list, weights, verbose = TRUE)
}
\arguments{
\item{corr_matrix}{An \code{\link[bigstatsr]{FBM}} object.}

\item{matrix_list}{A list of \code{bigstatsr::FBM} objects.}

\item{weights}{A numeric vector of weights for each dataset or batch.}
}
\value{
A list with statistical measures including \code{mean}, \code{sd},
\code{var}, \code{min}, and \code{max}.

A new \code{bigstatsr::FBM} object containing the mean values.

A list containing three matrices: \code{mean_zscore},
\code{sds_zscore}, and \code{sn_zscore} which are later used to
filter gene pairs based on the absolute mean z-score and signal-to-noise
ratio of the angles.
}
\description{
A collection of utility functions used within the
\pkg{anglemania} package for calculating statistics based
on the results created during the anglemania function.
}
\section{Functions}{
\itemize{
\item \code{get_dstat()}: Compute mean, standard deviation, variance,
min, and max of a correlation matrix stored as an
\code{\link[bigstatsr]{FBM}}.

\item \code{big_mat_list_mean()}: Calculates the element-wise mean from a list
of \code{bigstatsr::FBM} objects.

\item \code{get_list_stats()}: Calculate mean, standard deviation, and SNR
across a list of FBMs.

}}
\examples{
s_mat <- Matrix::rsparsematrix(nrow = 10, ncol = 5, density = 0.3)
fbm_mat <- sparse_to_fbm(s_mat)
result <- get_dstat(fbm_mat)
str(result)
result
# Create FBMs
mat1 <- matrix(1:9, nrow = 3)
mat2 <- matrix(1:9, nrow = 3)

fbm1 <- bigstatsr::FBM(nrow = nrow(mat1), ncol = ncol(mat1), init = mat1)
fbm2 <- bigstatsr::FBM(nrow = nrow(mat2), ncol = ncol(mat2), init = mat2)

# Create weights
weights <- c(batch1 = 0.5, batch2 = 0.5)

# Create the list of FBMs
fbm_list <- list(batch1 = fbm1, batch2 = fbm2)

big_mat_list_mean(fbm_list, weights)
library(SingleCellExperiment)
library(S4Vectors)
sce <- sce_example()
sce <- anglemania(sce, batch_key = "batch")
matrix_list <- metadata(sce)$anglemania$matrix_list
weights <- setNames(
  S4Vectors::metadata(sce)$anglemania$params$dataset_weights$weight,
  S4Vectors::metadata(sce)$anglemania$params$dataset_weights$anglemania_batch
)
list_stats <- get_list_stats(matrix_list, weights)
names(list_stats)
list_stats$mean_zscore[1:5, 1:5]
}
\seealso{
\code{\link[bigstatsr]{big_apply}}, \code{\link[bigstatsr]{FBM}}

\code{\link[bigstatsr]{big_apply}}, \code{\link[bigstatsr]{FBM}}
}
\keyword{internal}
