% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anota2seqAllGenerics.R, R/anota2seqMethods.R
\docType{methods}
\name{anota2seqGetResidOutlierTest}
\alias{anota2seqGetResidOutlierTest}
\alias{anota2seqGetResidOutlierTest,Anota2seqDataSet-method}
\title{Retrieve residOutlierTest}
\usage{
anota2seqGetResidOutlierTest(object)

\S4method{anota2seqGetResidOutlierTest}{Anota2seqDataSet}(object)
}
\arguments{
\item{object}{An Anota2seqDataSet.}
}
\value{
A list with the following items:
\itemize{
\item confInt: The selected confInt (see function arguments).
\item rnormIter: The number of sampled data sets.
\item outlierMatrixLog: A logical matrix describing which residuals were outliers
in the last iteration of the analysis.
\item meanOutlierPerIteration: The fraction outliers per iteration.
\item obtainedComparedToExpected: The ratio of the expected number of outlier
residuals compared to the expected number of outliers given the selected 
confInt.
\item nExpected Number of expected outlier residuals.
\item nObtained Number of obtained outliers residuals.
}
}
\description{
Retrieves the output of the anota2seqResidualOutlierTest function from the
Anota2seqDataSet.
}
\examples{

data(anota2seq_data)
Anota2seqDataSet <- anota2seqDataSetFromMatrix(
    dataP = anota2seq_data_P[1:100,],
    dataT = anota2seq_data_T[1:100,],
    phenoVec = anota2seq_pheno_vec,
    dataType = "RNAseq",
    normalize = TRUE)
# Run QC, it is mandatory for anota2seqResidualOutlierTest
Anota2seqDataSet <- anota2seqPerformQC(Anota2seqDataSet)
# Run the Residual outlier testing
Anota2seqDataSet <- anota2seqResidOutlierTest(Anota2seqDataSet)

#Get resdidual outlier testing
rot <- anota2seqGetResidOutlierTest(Anota2seqDataSet)

}
\seealso{
\code{\link{anota2seqResidOutlierTest}}
}
