% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svalue.R
\name{svalue}
\alias{svalue}
\title{Local FSR to svalue}
\usage{
svalue(lfsr)
}
\arguments{
\item{lfsr}{the local false sign rates}
}
\value{
s-values
}
\description{
Convert local FSR to svalue by taking the cumulative mean of
increasing local FSRs.
This is used within \code{apeglm} to generate the svalue table,
but provided as convenience function.
}
\examples{

# Example 1 -- simulated local FSR data
local.fsr <- runif(1000)
sval <- svalue(local.fsr)

# Example 2 -- first runs example from 'apeglm'
example("apeglm")
local.fsr <- res$fsr[1, ]
sval <- svalue(local.fsr)

}
\references{
False sign rate and s-value:

Stephens, M. (2016) False discovery rates: a new deal. Biostatistics, 18:2. doi: 10.1093/biostatistics/kxw041
}
