% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_read_annotations.R
\name{add_psp}
\alias{add_psp}
\title{Add psp}
\usage{
add_psp(
  object,
  pspfile = file.path(R_user_dir("autonomics", "cache"), "phosphositeplus",
    "Phosphorylation_site_dataset.gz")
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{pspfile}{phosphositeplus file}
}
\value{
SummarizedExperiment
}
\description{
Add PhosphoSitePlus literature counts
}
\details{
Go to www.phosphosite.org                   \cr
Register and Login.                         \cr
Download Phosphorylation_site_dataset.gz'.  \cr
Save into: file.path(R_user_dir('autonomics','cache'),'phosphositeplus')
}
\examples{
fosfile <- system.file('extdata/billing19.phosphosites.txt',  package = 'autonomics')
profile <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_phosphosites(fosfile = fosfile, profile = profile)
fdt(object)
object \%<>\% add_psp()
fdt(object)
}
