% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21_pca.R
\name{biplot_covariates}
\alias{biplot_covariates}
\title{Biplot covariates}
\usage{
biplot_covariates(
  object,
  method = "pca",
  by = "sample_id",
  block = NULL,
  covariates = "subgroup",
  ndim = 6,
  dimcols = 1,
  varcols = length(covariates),
  plot = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{method}{'pca', 'pls', 'lda', or 'sma'}

\item{by}{svar}

\item{block}{svar}

\item{covariates}{covariates: mapped to color or batch-corrected}

\item{ndim}{number of dimensions to plot}

\item{dimcols}{number of dimension columns}

\item{varcols}{number of covariate columns}

\item{plot}{TRUE or FALSE: whether to plot}
}
\value{
ggplot object
}
\description{
Biplot covariates
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file, pca = TRUE)
biplot_covariates(object, covariates = 'subgroup', ndim = 12, dimcols = 3)
biplot_covariates(object, covariates = c('Sex', 'Diabetes', 'Subject', 'Time'))
biplot_covariates(object, covariates = c('Sex', 'Diabetes', 'Subject', 'Time'), ndim = 2)
biplot_covariates(object, covariates = c('subgroup'), dimcols = 3)
}
\seealso{
biplot_corrections
}
