% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_plot.R
\name{plot_densities}
\alias{plot_densities}
\alias{plot_sample_densities}
\alias{plot_feature_densities}
\title{Plot sample/feature distributions}
\usage{
plot_densities(
  object,
  assay = assayNames(object)[1],
  group,
  fill,
  color = NULL,
  linetype = NULL,
  facet = NULL,
  nrow = NULL,
  ncol = NULL,
  dir = "h",
  scales = "free_y",
  labeller = label_value,
  palette = NULL,
  fixed = list(alpha = 0.8, na.rm = TRUE)
)

plot_sample_densities(
  object,
  assay = assayNames(object)[1],
  group = "sample_id",
  fill = if ("subgroup" \%in\% svars(object)) "subgroup" else "sample_id",
  color = NULL,
  linetype = NULL,
  n = 100,
  facet = NULL,
  nrow = NULL,
  ncol = NULL,
  dir = "h",
  scales = "free_y",
  labeller = label_value,
  palette = NULL,
  fixed = list(alpha = 0.8, na.rm = TRUE)
)

plot_feature_densities(
  object,
  assay = assayNames(object)[1],
  fill = "feature_id",
  group = fill,
  color = NULL,
  linetype = NULL,
  n = 9,
  facet = NULL,
  nrow = NULL,
  ncol = NULL,
  dir = "h",
  scales = "free",
  labeller = label_value,
  palette = NULL,
  fixed = list(alpha = 0.8, na.rm = TRUE)
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{assay}{string}

\item{group}{svar (string)}

\item{fill}{svar (string)}

\item{color}{svar (string)}

\item{linetype}{svar (string)}

\item{facet}{svar (character vector)}

\item{nrow}{number of facet rows}

\item{ncol}{number of facet cols}

\item{dir}{'h' (horizontal) or 'v' (vertical)}

\item{scales}{'free', 'fixed', 'free_y'}

\item{labeller}{e.g. label_value}

\item{palette}{named character vector}

\item{fixed}{fixed aesthetics}

\item{n}{number}
}
\value{
ggplot object
}
\description{
Plot sample/feature distributions
}
\examples{
# Data
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    object \%<>\% extract(, order(.$subgroup))
    
# Sample distributions
    plot_sample_densities(object)
    plot_sample_violins(  object, facet = 'Time')
    plot_sample_boxplots(object)
    plot_exprs(object)
    plot_exprs(object, dim = 'samples', x = 'subgroup', facet = 'Time')
    
# Feature distributions
    plot_feature_densities(object)
    plot_feature_violins(  object)
    plot_feature_boxplots( object)
}
\seealso{
\code{\link{plot_sample_violins}},
         \code{\link{plot_sample_boxplots}}
}
