% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_read_proteingroups.R
\name{sbind}
\alias{sbind}
\alias{fbind}
\alias{abind}
\title{Sample/Feature/Assay bind}
\usage{
sbind(obj1, obj2)

fbind(obj1, obj2)

abind(obj1, obj2)
}
\arguments{
\item{obj1}{SummarizedExperiment:       nrow1 x ncol1}

\item{obj2}{SummarizedExperiment:       nrow2 x ncol2}
}
\value{
SummarizedExperiment: nrow1+nrow2 x ncol1+ncol2
}
\description{
Sample/Feature/Assay bind
}
\examples{
# Data
    obj1 <- object1()
    obj2 <- object2()
    biplot( pca(obj1), color = 'age')
    biplot( pca(obj2), color = 'age')

# Sample bind
    obj <- sbind(obj1, obj2)
    biplot( pca(obj), color = 'age', shape = 'set')
    sdt(obj)  # SET added
    fdt(obj)  # common fvars with differing content pasted together

# Feature bind
    obj <- fbind(obj1, obj2)
    biplot( pca(obj), color = 'age', nx = 2)
    fdt(obj)  # SET added
    sdt(obj)  # common svars with differing content pasted together

# Assay bind
    obj <- abind(obj1, obj2)
    plot( SummarizedExperiment::assays(abind(obj1, obj2))$SET1.exprs, 
          SummarizedExperiment::assays(abind(obj1, obj2))$SET2.exprs)
    fdt(obj)  # common fvars with differing content pasted together
    sdt(obj)  # common svars with differing content pasted together
}
