% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{topTable}
\alias{topTable}
\alias{topTable,Bacon-method}
\title{topTable}
\usage{
topTable(
  object,
  number = 10,
  adjust.method = "bonf",
  sort.by = c("pval", "eff.size")
)

\S4method{topTable}{Bacon}(
  object,
  number = 10,
  adjust.method = "bonf",
  sort.by = c("pval", "eff.size")
)
}
\arguments{
\item{object}{'bacon'-object}

\item{number}{return specified number of top features, n=-1 return all features}

\item{adjust.method}{P-value multiple testing adjustment method default bonferroni}

\item{sort.by}{order results by pval or eff.size}
}
\value{
table with top features
}
\description{
Extract top features after meta analysis
}
\examples{
es <- replicate(6, rnormmix(2000, c(0.9, 0, 1, 0, 4, 1)))
se <- replicate(6, 0.8*sqrt(4/rchisq(2000,df=4)))
bc <- bacon(NULL, es, se)
mbc <- meta(bc)
topTable(mbc)
}
\seealso{
\code{\link{bacon}}
}
