% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-plots.R
\name{plotConvergence}
\alias{plotConvergence}
\title{Generates a histogram of ranks (a rank plot) for convergence}
\usage{
plotConvergence(params)
}
\arguments{
\item{params}{An instance of class \code{bandleParams}}
}
\value{
Returns the ranks of the number of outliers in each chain. The
side effect returns rank plots. Number of rank plots is equal to the number
of chains
}
\description{
Produces a rank plot to analyse convergence of MCMC algorithm
}
\examples{
## Generate some example data
library("pRolocdata")
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                      numRep = 4L,
                      numDyn = 100L)
data <- tansim$lopitrep
control <- data[1:2]
treatment <- data[3:4]

## fit GP params
gpParams <- lapply(tansim$lopitrep, function(x) 
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))

## run bandle
res <- bandle(objectCond1 = control,
              objectCond2 = treatment, 
              gpParams = gpParams,
              fcol = "markers",  
              numIter = 5L, 
              burnin = 1L, 
              thin = 2L,
              numChains = 2, 
              BPPARAM = SerialParam(RNGseed = 1),
              seed = 1)
               
## Process bandle results
bandleres <- bandleProcess(res)

## Convergence plots
par(mfrow = c(1, 2))
plotConvergence(bandleres)  
}
