# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Binomial downsampling
#'
#' @description For each element in the \code{Data},
#' randomly generate a number using Binomial distribution with
#' probability equal to the specific capture efficiency.
#'
#' @param Data raw count Data
#' @param BETA_vec A vector of capture efficiencies of cells
#'
#' @return A matrix of binomial downsampling data.
#'
#' @examples
#' data("EXAMPLE_DATA_list")
#' Downsample_data<-DownSampling(Data=EXAMPLE_DATA_list$inputdata
#' ,BETA_vec = EXAMPLE_DATA_list$inputbeta)
#' @export
#'
DownSampling <- function(Data, BETA_vec) {
    .Call('_bayNorm_DownSampling', PACKAGE = 'bayNorm', Data, BETA_vec)
}

MarginalF_NB_1D <- function(SIZE, MU, m_observed, BETA) {
    .Call('_bayNorm_MarginalF_NB_1D', PACKAGE = 'bayNorm', SIZE, MU, m_observed, BETA)
}

MarginalF_NB_2D <- function(SIZE_MU, m_observed, BETA) {
    .Call('_bayNorm_MarginalF_NB_2D', PACKAGE = 'bayNorm', SIZE_MU, m_observed, BETA)
}

GradientFun_NB_1D <- function(SIZE, MU, m_observed, BETA) {
    .Call('_bayNorm_GradientFun_NB_1D', PACKAGE = 'bayNorm', SIZE, MU, m_observed, BETA)
}

GradientFun_NB_2D <- function(SIZE_MU, m_observed, BETA) {
    .Call('_bayNorm_GradientFun_NB_2D', PACKAGE = 'bayNorm', SIZE_MU, m_observed, BETA)
}

Main_NB_Bay <- function(Data, BETA_vec, size, mu, S, thres) {
    .Call('_bayNorm_Main_NB_Bay', PACKAGE = 'bayNorm', Data, BETA_vec, size, mu, S, thres)
}

Main_mean_NB_Bay <- function(Data, BETA_vec, size, mu, S, thres) {
    .Call('_bayNorm_Main_mean_NB_Bay', PACKAGE = 'bayNorm', Data, BETA_vec, size, mu, S, thres)
}

Main_mode_NB_Bay <- function(Data, BETA_vec, size, mu, S, thres) {
    .Call('_bayNorm_Main_mode_NB_Bay', PACKAGE = 'bayNorm', Data, BETA_vec, size, mu, S, thres)
}

rowMeansFast <- function(x) {
    .Call('_bayNorm_rowMeansFast', PACKAGE = 'bayNorm', x)
}

rowVarsFast <- function(x, means) {
    .Call('_bayNorm_rowVarsFast', PACKAGE = 'bayNorm', x, means)
}

#' @title Estimate size and mu for Negative Binomial distribution
#' for each gene using MME method (Rcpp version, sp_mat)
#'
#' @description  Input raw data and return
#' estimated size and mu for each gene using the MME method.
#' @param Data A matrix of single-cell expression where rows
#' are genes and columns are samples (cells). \code{Data}
#' can be of class \code{SummarizedExperiment} (the
#' assays slot contains the expression matrix and
#' is named "Counts") or just matrix.
#' @details mu and size are two parameters of the prior that
#' need to be specified for each gene in bayNorm.
#' They are parameters of negative binomial distribution.
#' The variance is \eqn{mu + mu^2/size} in this parametrization.
#'
#' @return  List containing estimated mu and
#' size for each gene.
#'
#' @examples
#' data("EXAMPLE_DATA_list")
#' #Should not run by the users, it is used in prior estimation.
#' \dontrun{
#' }
#' @export
EstPrior_sprcpp <- function(Data) {
    .Call('_bayNorm_EstPrior_sprcpp', PACKAGE = 'bayNorm', Data)
}

#' @title Estimate size and mu for Negative Binomial distribution
#' for each gene using MME method (Rcpp version)
#'
#' @description  Input raw data and return
#' estimated size and mu for each gene using the MME method.
#' @param Data A matrix of single-cell expression where rows
#' are genes and columns are samples (cells). \code{Data}
#' can be of class \code{SummarizedExperiment} (the
#' assays slot contains the expression matrix and
#' is named "Counts") or just matrix.
#' @details mu and size are two parameters of the prior that
#' need to be specified for each gene in bayNorm.
#' They are parameters of negative binomial distribution.
#' The variance is \eqn{mu + mu^2/size} in this parametrization.
#'
#' @return  List containing estimated mu and
#' size for each gene.
#'
#' @examples
#' data("EXAMPLE_DATA_list")
#' #Should not run by the users, it is used in prior estimation.
#' \dontrun{
#' }
#' @export
EstPrior_rcpp <- function(Data) {
    .Call('_bayNorm_EstPrior_rcpp', PACKAGE = 'bayNorm', Data)
}

#' @title Transpose of sparse matrix
#'
#' @description  Transpose of sparse matrix
#' @param Data A matrix of single-cell expression where rows
#' are genes and columns are samples (cells). \code{Data}
#' can be of class \code{SummarizedExperiment} (the
#' assays slot contains the expression matrix and
#' is named "Counts") or just matrix.
#' @details Transpose of sparse matrix.
#'
#' @return  Transpose of sparse matrix.
#'
#' @examples
#' data("EXAMPLE_DATA_list")
#' #Should not run by the users, it is used in prior estimation.
#' \dontrun{
#' }
#' @export
t_sp <- function(Data) {
    .Call('_bayNorm_t_sp', PACKAGE = 'bayNorm', Data)
}

#' @title Rcpp version: as.matrix
#'
#' @description  Rcpp version: as.matrix
#' @param rp vector
#' @param cp vector
#' @param z vector
#' @param nrows nrows
#' @param ncols ncols
#' @details Rcpp version: as.matrix
#'
#' @return  Matrix object in R.
#'
#' @examples
#' data("EXAMPLE_DATA_list")
#' #Should not run by the users, it is used in prior estimation.
#' \dontrun{
#' }
#' @export
asMatrix <- function(rp, cp, z, nrows, ncols) {
    .Call('_bayNorm_asMatrix', PACKAGE = 'bayNorm', rp, cp, z, nrows, ncols)
}

Main_mean_NB_spBay <- function(Data, BETA_vec, size, mu, S, thres) {
    .Call('_bayNorm_Main_mean_NB_spBay', PACKAGE = 'bayNorm', Data, BETA_vec, size, mu, S, thres)
}

