% modification on git from copied files
% modification on git from copied files
\name{methObservables}
\alias{methObservables}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generation of intermediate values in likelihood estimation for methylation
data.
}
\description{
  Estimating prior and posterior values for methylation data that
  account for non-conversion rates is a time-consuming
  process. Significant increases in speed can be made by calculating in
  advance sets of data that will be re-used at several points of these
  analyses. This function populates the '@cellObservables' slot of a
  `countData' object that contains a `nonconversion' object in the
  `@sampleObservables' slot.
}
\usage{
methObservables(mD, tail = 0.01)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{mD}{
    A \code{\link{countData}} object, or descendant, which contains a
    numeric vector 'nonconversion' in the `@sampleObservables' slot.
  }
  \item{tail}{A cutoff on the quantile (upper and lower) of the
    distribution on the non-conversion. Smaller values will give a
    marginal increase in accuracy at high computational cost. Large
    values will decrease accuracy somewhat but reduce the time needed
    for analysis. See Details.
    }

}

\details{For loci with large numbers of observed cytosines, the full dataset
  to be pre-computed will be very large. However, only the
  pre-computations near the average expression level will contribute
  significantly to the estimated priors and posteriors. The `tail'
  parameter sets the quantile at which the distribution is considered to
  no longer contribute significantly to the results. Values below 0.1
  are probably acceptable under nearly all circumstances.
}

\value{
A \code{\link{countData}} object with the '@cellObservables' slot
populated with temporary values useful in the faster calculation of likelihoods.
}
\author{
  Thomas J. Hardcastle
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{manip}
