% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAB.R
\name{getAB}
\alias{getAB}
\title{Estimate beads-only shape parameters}
\usage{
getAB(object, method = "mom", ...)
}
\arguments{
\item{object}{a \code{\link[PhIPData]{PhIPData}} object or a vector}

\item{method}{one of \code{c("edgeR", "mle", "mom")} designating which method
to use to estimate beads-only prior parameters. MOM is the default method
used to estimate shape parameters.}

\item{...}{parameters passed to specific estimating functions. See details
for more information}
}
\value{
a data frame of beta shape parameters where each row corresponds to
a peptide.
}
\description{
Beta shape parameters are estimated using the proportion of
reads-pulled per peptide across the beads-only samples. Currently, only three
estimation methods are supported: edgeR, method of moments (MOM),
maximum likelihood (MLE). Note that edgeR can only be used on
\code{\link[PhIPData]{PhIPData}} objects while MOM and MLE methods can also
be applied to vectors of values between 0 and 1. Parameters that can be
passed to each method are listed in the details.
}
\details{
\strong{edgeR} derived estimates rely on edgeR's peptide-specific
dispersion estimates, denoted \eqn{\phi^{edgeR}}. \eqn{\phi^{edgeR}}
corresponds to the squared coefficient of variation for the proportion of
reads pulled for a given peptide. Using \eqn{\phi^{edgeR}} to derive an
estimate of the variance for the proportion of reads pulled by a single
peptide, the mean and variance are transformed into shape parameters
satisfying the lower and upper bounds. When \code{method = "edgeR"}, the
following additional parameters can be specified.

\itemize{
    \item \code{threshold.cpm}: CPM threshold to be considered present in
    a sample.
    \item \code{threshold.prevalence}: proportion of beads-only samples
    that surpass \code{threshold.cpm}.
    \item \code{lower}: minimum value of the beta shape parameters.
    \item \code{upper}: maximum value of the beta shape parameters.
}

\strong{Method of Moments (MOM)} estimates are derived by transforming the
sample mean and variance to shape parameters of the beta distribution. For
\code{method = "mom"}, the following parameters can be adjusted:

\itemize{
    \item \code{offsets}: vector defining the offset to use when the mean
    and/or variance are zero.
    \item \code{lower}: lower bound for the shape parameters.
    \item \code{upper}: upper bound for the shape parameters.
    \item \code{...}: parameters passed to \code{[base::mean]} and
    \code{[stats::var]}.
}

\strong{Maximum Likelihood (MLE)} estimates rely on
\code{[stats::optim]} to derive shape parameters that maximize the
likelihood of observed data. By default the L-BFGS-B optimization method is
used. Parameters for MLE estimates include:

\itemize{
     \item \code{prop.offset}: offset to use when the proportion of reads
     is 0.
     \item \code{optim.method}: optimization method passed to
     \code{[stats::optim]}.
     \item \code{lower}: lower bound for the shape parameters.
     \item \code{upper}: upper bound for the shape parameters.
}
}
\examples{
## PhIPData object
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

getAB(sim_data, method = "edgeR")
getAB(sim_data, method = "mle")
getAB(sim_data, method = "mom")

## Vector of proportions
prop <- rbeta(100, 2, 8)
getAB(prop, method = "mle")
getAB(prop, method = "mom")
}
