% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessInits.R
\name{guessInits}
\alias{guessInits}
\title{Derive initial estimates of unknown model parameters}
\usage{
guessInits(object, beads.prior)
}
\arguments{
\item{object}{a \code{\link[PhIPData]{PhIPData}} object}

\item{beads.prior}{a data frame with two columns (named a_0, b_0) containing
estimated shape parameters from beads-only samples.}
}
\value{
a list of estimated initial values.
}
\description{
To reduce converge time and to reduce the likelihood of the
slice sampler getting stuck, we use maximum likelihood to derive initial
estimates for unknown model parameters.
}
\details{
Briefly initial values are defined as follows:
\enumerate{
    \item \code{theta_guess[i, j] = Y[i, j]/n[j]}, or the the MLE for theta.
    \item \code{Z_guess[i, j] = 1} if \eqn{j} is a serum sample, and the
    observed read count is >2x the expected read count assuming
    \code{c[j] = 1}.
    \item \code{pi_guess[j]} is the mean of column \eqn{j} in \code{Z_guess}.
    \item \code{c_guess[j]} is the estimated slope from regressing the
    observed read counts against the expected read counts (without adjusting
    for the attenuation constant) for non-enriched peptides only.
    \item \code{phi_guess[i,j]} is the ratio of the observed read counts to
    the expected read counts multiplied by the attenuation constant.
}
}
\seealso{
\emph{Methods} in [Chen et. al 2022](https://www.biorxiv.org/content/10.1101/2022.01.19.476926v1)
}
