% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{biscuiteer-methods}
\alias{biscuiteer-methods}
\alias{BSseq-methods}
\alias{coverage}
\alias{header}
\alias{reference}
\alias{samples,BSseq-method}
\alias{header,BSseq-method}
\alias{meta,BSseq-method}
\alias{fixed,BSseq-method}
\alias{info,BSseq-method}
\alias{geno,BSseq,ANY-method}
\title{bsseq class methods (VCF-centric) added by biscuiteer}
\usage{
\S4method{samples}{BSseq}(object)

\S4method{header}{BSseq}(x)

\S4method{meta}{BSseq}(x)

\S4method{fixed}{BSseq}(x)

\S4method{info}{BSseq}(x)

\S4method{geno}{BSseq,ANY}(x)
}
\arguments{
\item{object}{A bsseq object, preferably with !is.null(metadata(x)$vcfHeader)}

\item{x}{A bsseq object, preferably with !is.null(metadata(x)$vcfHeader)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{  Depends on the method - usually a List-like object of some sort
}\if{html}{\out{</div>}}
}
\description{
See biscuiteer manpage for package description
}
\details{
biscuiteer adds VariantAnnotation methods to BSseq objects with VCF headers:
\code{samples},\code{header},\code{meta},\code{fixed},\code{info},\code{geno}

Due to inherited method signatures, the argument (singular) to the method may
be named \code{x} or it may be named \code{object}. Either way, it is a BSseq object.

These add to the existing methods defined in package bsseq for class BSseq:
\code{[},\code{length},\code{sampleNames},\verb{sampleNames<-},\code{pData},\verb{pData<-},\code{show},\code{combine}

Those add to the methods BSseq inherits from SummarizedExperiment, such as:
\code{colData},\code{rowRanges},\code{metadata},\code{subset},\code{subsetByOverlaps},\code{isDisjoint},&c.

Most of the biscuiteer methods operate on the VCF header, which readBiscuit
likes to stuff into the \code{metadata} slot of BSseq objects it produces. Some
may be handy for populating a BSseq object with QC stats, or querying those.
}
\seealso{
RangedSummarizedExperiment

VCFHeader-class

BSseq-class

BSseq
}
