% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{outlier_heatmap}
\alias{outlier_heatmap}
\title{With the grouptablist generated by count_outliers - run through and run a
    fisher exact test to get the p.value for the difference in outlier count
    for each feature in each of your comparisons}
\usage{
outlier_heatmap(outlier_analysis_out, analysis_num = NULL,
    counttab, metatable, fdrcutoffvalue = 0.1)
}
\arguments{
\item{outlier_analysis_out}{the full outlier_analysis data objet}

\item{analysis_num}{DEFAULT: NULL; if you only want to plot the heatmap for
a particular analysis, enter number of that analysis}

\item{counttab}{the raw data before outlier analysis}

\item{metatable}{the complete metatable that was used to generate the
comparisons, will be used for annotation of the heatmap}

\item{fdrcutoffvalue}{DEFAULT: 0.1; The FDR value for significance}
}
\value{
outputs a pdf with the heatmap in the current working directory
}
\description{
With the grouptablist generated by count_outliers - run through and run a
    fisher exact test to get the p.value for the difference in outlier count
    for each feature in each of your comparisons
}
\examples{

data("sample_phosphodata")
reftable_function_out <- make_outlier_table(sample_phosphodata[1:1000,])
outliertab <- reftable_function_out$outliertab

data("sample_annotationdata")
groupings <- comparison_groupings(sample_annotationdata)

count_outliers_out <- count_outliers(groupings, outliertab,
    aggregate_features = FALSE)
grouptablist <- count_outliers_out$grouptablist
fractiontab <- count_outliers_out$fractiontab

outlier_analysis_out <- outlier_analysis(grouptablist,
    fraction_table = fractiontab)

metatable <- sample_annotationdata
counttab <- sample_phosphodata

hm1 <- outlier_heatmap(outlier_analysis_out, analysis_num = NULL,
    fractiontab, metatable, fdrcutoffvalue = 0.1)
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
