% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCompositeFile.R
\name{createCompositeFile}
\alias{createCompositeFile}
\title{Create composite Strand-seq file}
\usage{
createCompositeFile(
  file.list,
  chromosomes = NULL,
  pairedEndReads = TRUE,
  pair2frgm = FALSE,
  min.mapq = 10,
  filtAlt = FALSE,
  WC.cutoff = 0.9,
  genoT = "fisher",
  background = 0.05
)
}
\arguments{
\item{file.list}{A list of BAM files to process.}

\item{chromosomes}{If only a subset of the chromosomes should be binned, specify them here.}

\item{pairedEndReads}{Set to \code{TRUE} if you have paired-end reads in your file.}

\item{pair2frgm}{Set to \code{TRUE} if every paired-end read should be merged into a single fragment.}

\item{min.mapq}{Minimum mapping quality when importing from BAM files.}

\item{filtAlt}{Set to \code{TRUE} if you want to filter out alternative alignments defined in 'XA' tag.}

\item{WC.cutoff}{Percentage of WW or CC reads to consider chromosome being WW or CC}

\item{genoT}{A method ('fisher' or 'binom') to genotype regions defined by a set of breakpoints.}

\item{background}{The percent (e.g. 0.05 = 5\%) of background reads allowed for WW or CC genotype calls.}
}
\value{
A \code{\link{GRanges-class}} object.
}
\description{
This function will move through BAM files in a folder, read in each individual file and go through each chromosome, 
determine if the chromosome is WW or CC based on WCcutoff, reverse complement all reads in the WW file,
append to a new composite file for that chromosome, order the composite file of each chromosome based on position.
}
\author{
Ashley Sanders, David Porubsky
}
