% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotBreakpointsPerChr}
\alias{plotBreakpointsPerChr}
\title{Plotting chromosome specific ideograms \pkg{\link{breakpointR}}}
\usage{
plotBreakpointsPerChr(files2plot, plotspath = NULL, chromosomes = NULL)
}
\arguments{
\item{files2plot}{A list of files that contains \code{\link{BreakPoint}} objects or a single \code{\link{BreakPoint}} object.}

\item{plotspath}{Directory to store plots.}

\item{chromosomes}{Set specific chromosome(s) to be plotted.}
}
\value{
A list with \code{\link[ggplot2:ggplot]{ggplot}} objects.
}
\description{
This function will create chromsome specific enome-wide ideograms from a \code{\link{BreakPoint}} object.
}
\examples{
## Get an example file
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
exampleFiles <- list.files(exampleFolder, full.names=TRUE)
## Plot results
plotBreakpointsPerChr(exampleFiles, chromosomes='chr7')

}
\author{
David Porubsky
}
