% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportUCSC.R
\name{ranges2UCSC}
\alias{ranges2UCSC}
\title{Generates a bedfile from an input GRanges file}
\usage{
ranges2UCSC(gr, outputDirectory = ".", index = "bedFile", colorRGB = "0,0,0")
}
\arguments{
\item{gr}{A \code{\link{GRanges-class}} object with genomic ranges to be exported into UCSC format.}

\item{outputDirectory}{Location to write bedfile(s).}

\item{index}{A character used to name the bedfile(s).}

\item{colorRGB}{An RGB color to be used for submitted ranges.}
}
\value{
\code{NULL}
}
\description{
Write a bedfile from Breakpoint.R files for upload on to UCSC Genome browser
}
\examples{
## Get an example file
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
exampleFile <- list.files(exampleFolder, full.names=TRUE)[1]
## Load the file 
counts <- get(load(exampleFile))[['counts']]
## Export 'wc' states into a UCSC formated file
ranges2UCSC(gr=counts[counts$states == 'wc'], index='testfile', outputDirectory=tempdir())
}
\author{
David Porubsky
}
