% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brendaDb.R
\docType{package}
\name{brendaDb-package}
\alias{brendaDb}
\alias{brendaDb-package}
\title{brendaDb: the BRENDA enzyme database.}
\description{
brendaDb provides an R interface to download, clean and extract enzyme
information from the BRENDA database.
}
\details{
The main aims of brendaDb include:
\itemize{
\item Read text file downloaded from BRENDA into an R \code{tibble}
\item Retrieve information for specific enzymes
\item Query enzymes using their synonyms, gene symbols, etc.
\item Query enzyme information for specific \href{https://biocyc.org}{BioCyc} pathways
}

To learn more about brendaDb, please refer to the vignette.
\code{browseVignettes(package = "brendaDb")}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/y1zhou/brendaDb}
  \item Report bugs at \url{https://github.com/y1zhou/brendaDb/issues}
}

}
\author{
\strong{Maintainer}: Yi Zhou \email{yi.zhou@uga.edu} (\href{https://orcid.org/0000-0003-0969-3993}{ORCID})

}
