% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTRAP-package.r
\docType{data}
\name{cmapPerturbationsCompounds}
\alias{cmapPerturbationsCompounds}
\title{CMap perturbations sample for small molecules}
\description{
CMap perturbations sample for small molecules obtained by running the
following code:

\preformatted{
cellLine <- c("HepG2", "HUH7")
cmapMetadataCompounds <- filterCMapMetadata(
    "cmapMetadata.txt", cellLine=cellLine, timepoint="24 h",
    dosage="5 \u00B5M", perturbationType="Compound")

cmapPerturbationsCompounds <- prepareCMapPerturbations(
    cmapMetadataCompounds, "cmapZscores.gctx", "cmapGeneInfo.txt",
    "cmapCompoundInfo_drugs.txt", loadZscores=TRUE)

# Remove non-ASCII characters for portability reasons
metadata <- attr(cmapPerturbationsCompounds, "metadata")
metadata$pert_idose <- gsub("\u00B5", "micro", metadata$pert_idose)
metadata$pert_dose_unit <- gsub("\u00B5", "micro", metadata$pert_dose_unit)
attr(cmapPerturbationsCompounds, "metadata") <- metadata
}
}
\keyword{internal}
