% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugSensitivity.R
\name{loadExpressionDrugSensitivityAssociation}
\alias{loadExpressionDrugSensitivityAssociation}
\title{Load gene expression and drug sensitivity correlation matrix}
\usage{
loadExpressionDrugSensitivityAssociation(
  source,
  file = NULL,
  path = NULL,
  rows = NULL,
  cols = NULL,
  loadValues = FALSE
)
}
\arguments{
\item{source}{Character: source of matrix to load; see
\code{\link{listExpressionDrugSensitivityAssociation}}}

\item{file}{Character: filepath to gene expression and drug sensitivity
association dataset (automatically downloaded if file does not exist)}

\item{path}{Character: folder where to find files (optional; \code{file} may
contain the full filepath if preferred)}

\item{rows}{Character or integer: rows}

\item{cols}{Character or integer: columns}

\item{loadValues}{Boolean: load data values (if available)? If \code{FALSE},
downstream functions will load and process directly from the file chunk by
chunk, resulting in a lower memory footprint}
}
\value{
Correlation matrix between gene expression (rows) and drug
  sensitivity (columns)
}
\description{
Load gene expression and drug sensitivity correlation matrix
}
\examples{
gdsc <- listExpressionDrugSensitivityAssociation()[[1]]
loadExpressionDrugSensitivityAssociation(gdsc)
}
\seealso{
Other functions related with the prediction of targeting drugs: 
\code{\link{as.table.referenceComparison}()},
\code{\link{listExpressionDrugSensitivityAssociation}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{predictTargetingDrugs}()}
}
\concept{functions related with the prediction of targeting drugs}
