% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{parseCMapID}
\alias{parseCMapID}
\title{Parse CMap identifier}
\usage{
parseCMapID(id, cellLine = FALSE)
}
\arguments{
\item{id}{Character: CMap identifier}

\item{cellLine}{Boolean: if \code{TRUE}, return cell line information from
CMap identifier; else, return the CMap identifier without the cell line}
}
\value{
Character vector with information from CMap identifiers
}
\description{
Parse CMap identifier
}
\examples{
id <- c("CVD001_HEPG2_24H:BRD-K94818765-001-01-0:4.8",
        "CVD001_HEPG2_24H:BRD-K96188950-001-04-5:4.3967",
        "CVD001_HUH7_24H:BRD-A14014306-001-01-1:4.1")
parseCMapID(id, cellLine=TRUE)
parseCMapID(id, cellLine=FALSE)
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{filterCMapMetadata}()},
\code{\link{getCMapConditions}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapData}()},
\code{\link{loadCMapZscores}()},
\code{\link{plot.perturbationChanges}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{prepareCMapPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}
}
\concept{functions related with the ranking of CMap perturbations}
