% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotTargetingDrugsVSsimilarPerturbations}
\alias{plotTargetingDrugsVSsimilarPerturbations}
\title{Plot similar perturbations against predicted targeting drugs}
\usage{
plotTargetingDrugsVSsimilarPerturbations(
  targetingDrugs,
  similarPerturbations,
  column,
  labelBy = "pert_iname",
  quantileThreshold = 0.25,
  showAllScores = FALSE,
  keyColTargetingDrugs = NULL,
  keyColSimilarPerturbations = NULL
)
}
\arguments{
\item{targetingDrugs}{\code{targetingDrugs} object}

\item{similarPerturbations}{\code{similarPerturbations} object}

\item{column}{Character: column to plot (must be available in both databases)}

\item{labelBy}{Character: column in \code{as.table(similarPerturbations)} or
\code{as.table(targetingDrugs)} to be used for labelling}

\item{quantileThreshold}{Numeric: quantile (between 0 and 1) to highlight
values of interest}

\item{showAllScores}{Boolean: show all scores? If \code{FALSE}, only the best
score per compound will be plotted}

\item{keyColTargetingDrugs}{Character: column from \code{targetingDrugs} to
compare with column \code{keyColSimilarPerturbations} from
\code{similarPerturbations}; automatically selected if \code{NULL}}

\item{keyColSimilarPerturbations}{Character: column from
\code{similarPerturbations} to compare with column
\code{keyColTargetingDrugs} from \code{targetingDrugs}; automatically
selected if \code{NULL}}
}
\value{
\code{ggplot2} plot
}
\description{
Plot similar perturbations against predicted targeting drugs
}
\examples{
# Rank similarity against CMap compound perturbations
similarPerts <- rankSimilarPerturbations(diffExprStat,
                                         cmapPerturbationsCompounds)

# Predict targeting drugs
gdsc <- loadExpressionDrugSensitivityAssociation("GDSC 7")
predicted <- predictTargetingDrugs(diffExprStat, gdsc)

plotTargetingDrugsVSsimilarPerturbations(predicted, similarPerts,
                                         "spearman_rank")
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{filterCMapMetadata}()},
\code{\link{getCMapConditions}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapData}()},
\code{\link{loadCMapZscores}()},
\code{\link{parseCMapID}()},
\code{\link{plot.perturbationChanges}()},
\code{\link{plot.referenceComparison}()},
\code{\link{prepareCMapPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}

Other functions related with the prediction of targeting drugs: 
\code{\link{as.table.referenceComparison}()},
\code{\link{listExpressionDrugSensitivityAssociation}()},
\code{\link{loadExpressionDrugSensitivityAssociation}()},
\code{\link{plot.referenceComparison}()},
\code{\link{predictTargetingDrugs}()}
}
\concept{functions related with the prediction of targeting drugs}
\concept{functions related with the ranking of CMap perturbations}
