% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{processByChunks}
\alias{processByChunks}
\title{Process data by chunks}
\usage{
processByChunks(
  data,
  FUN,
  num,
  ...,
  threads = 1,
  chunkGiB = 1,
  verbose = FALSE
)
}
\arguments{
\item{data}{Character containing a HDF5 file path (allowing partial loading)
or data matrix (processed as single chunk if data matrix)}

\item{FUN}{Function: function to run for each chunk}

\item{num}{Numeric: numbers of methods to run per chunk}

\item{...}{Arguments passed to \code{FUN}}

\item{threads}{Integer: number of parallel threads}

\item{chunkGiB}{Numeric: size (in gibibytes) of chunks to load
\code{reference} file; only if argument \code{reference} is a file path}

\item{verbose}{Boolean: print additional details?}
}
\value{
Results of running \code{FUN}
}
\description{
Process data by chunks
}
\note{
All rows from file are currently loaded when processing chunks.
}
\keyword{internal}
