% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{heat_matrix}
\alias{heat_matrix}
\title{Plot heatmap from a matrix}
\usage{
heat_matrix(mat, base_size = 12, digits = 2, show_value = FALSE)
}
\arguments{
\item{mat}{A matrix to show, column by x-axis and row by y-axis}

\item{base_size}{Numeric value for the base size in theme_bw}

\item{digits}{Integer value for the number of digits to show}

\item{show_value}{Logical value for showing the value for each element or not}
}
\value{
A ggplot heatmap visualization of the passed matrix.
}
\description{
Plot heatmap from a matrix
}
\examples{
mat <- matrix(rnorm(9), ncol = 3, nrow = 3) + diag(rnorm(3, 2, 0.1))
rownames(mat) <- paste0("sample_", letters[1:3])
colnames(mat) <- paste0("var_", 1:3)
heat_matrix(mat)

# Additional arguments. 
heat_matrix(mat, base_size = 6)
heat_matrix(mat, show_value = TRUE)
heat_matrix(mat, show_value = TRUE, digits = 4)
}
