% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbaf-xlsxOutput.R
\name{xlsxOutput}
\alias{xlsxOutput}
\title{Generate excel output for various studies/subgroups of a study.}
\usage{
xlsxOutput(submissionName, transposeResults = FALSE)
}
\arguments{
\item{submissionName}{a character string containing name of interest. It is
used for naming the process.}

\item{transposeResults}{a logical value that enables the function to replace
the columns and rows of data.}
}
\value{
It generates one excel file for each gene group. This excel file
contains output of automatedStatistics() and validation result from output of
either obtainOneStudy() or obtainMultipleStudies().
}
\description{
This function generates excel files containing gene validation
and all selected statistical methods. It uses outputs of
obtainOneStudy()/obtainMultipleStudies() and automatedStatistics() functions.
}
\details{
\tabular{lllll}{
Package: \tab cbaf \cr
Type: \tab Package \cr
Version: \tab 1.31.1 \cr
Date: \tab 2025-10-26 \cr
License: \tab Artistic-2.0 \cr
}
}
\examples{
genes <- list(K.demethylases = c("KDM1A", "KDM1B", "KDM2A", "KDM2B", "KDM3A",
 "KDM3B", "JMJD1C", "KDM4A"), K.methyltransferases = c("SUV39H1", "SUV39H2",
 "EHMT1", "EHMT2", "SETDB1", "SETDB2", "KMT2A", "KMT2A"))

obtainOneStudy(genes, "test", "Breast Invasive Carcinoma (TCGA, Cell 2015)",
"RNA-Seq", desiredCaseList = c(3,4))

automatedStatistics("test", obtainedDataType = "single study", calculate =
c("frequencyPercentage", "frequencyRatio"))

xlsxOutput("test")



}
\author{
Arman Shahrisa, \email{shahrisa.arman@hotmail.com} [maintainer,
copyright holder]

Maryam Tahmasebi Birgani, \email{tahmasebi-ma@ajums.ac.ir}
}
