# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computes rankings for each column of a matrix in parallel.
#'
#' @param x The input matrix to be ranked.
#' @param n_cores The number of CPU cores to use for parallel processing.
#' @return  A matrix where each column contains the rankings for the
#' corresponding column in the input matrix.
colRanks_fast <- function(x, n_cores) {
    .Call('_ccImpute_colRanks_fast', PACKAGE = 'ccImpute', x, n_cores)
}

#' Computes rankings for each column of a matrix in parallel.
#'
#' @param x The input matrix to be ranked.
#' @param n_cores The number of CPU cores to use for parallel processing.
#' @return  A matrix where each column contains the rankings for the
#' corresponding column in the input matrix.
sparseColRanks_fast <- function(x, n_cores) {
    .Call('_ccImpute_sparseColRanks_fast', PACKAGE = 'ccImpute', x, n_cores)
}

#' Computes a Weighted Pearson
#'
#' This function calculates weighted Pearson correlation matrix
#'
#' @param x The input matrix (dense), where each column represents a set of
#' observations.
#' @param w A vector of weights, one for each observation (must have the same
#' number of elements as rows in `x`).
#' @param n_cores The number of CPU cores to utilize for parallel computation.
#' @return A weighted Pearson correlation matrix 
wCor_fast <- function(x, w, n_cores) {
    .Call('_ccImpute_wCor_fast', PACKAGE = 'ccImpute', x, w, n_cores)
}

#' Computes a Pearson
#'
#' This function calculates a Pearson correlation matrix
#' 
#' @param x The input matrix, where each column represents a set of
#' observations.
#' @param n_cores The number of CPU cores to utilize for parallel computation
#' (optional, defaults to 1).
#' @return A Pearson correlation matrix if `useRanks` is `false`. If
#' `useRanks` is `true`, returns a Spearman correlation matrix.
cor_fast <- function(x, n_cores) {
    .Call('_ccImpute_cor_fast', PACKAGE = 'ccImpute', x, n_cores)
}

#' Computes Row Variances Efficiently
#' @param x A numeric dense matrix for which to compute row variances.
#' @param n_cores The number of cores to utilize for parallel processing.
#' @return A numeric vector containing the variance for each row of the input
#' matrix.
#' 
#' @examples
#'
#' library(Matrix)
#' rand_vals <- sample(0:10,1e4,replace=TRUE, p=c(0.99,rep(0.001,10)))
#' x <- as.matrix(Matrix(rand_vals,ncol=5))
#' cores <- 2
#' vars_vector <- rowVars_fast(x, cores)
#' 
#' @export
rowVars_fast <- function(x, n_cores) {
    .Call('_ccImpute_rowVars_fast', PACKAGE = 'ccImpute', x, n_cores)
}

#' This function calculates an average consensus matrix from a set of
#' clustering solutions. It filters out values below a specified minimum
#' threshold (`consMin`) and normalizes the remaining non-zero columns to sum
#' to 1.
#'
#' @param dat An integer matrix where each column represents a different
#' clustering solution (cluster assignments for each data point).
#' @param consMin The minimum consensus value to retain. Values below this
#' threshold are set to zero.
#' @param n_cores The number of cores to use for parallel processing.
#' This can speed up the normalization step.
#' @return A processed consensus matrix where each element (i, j) represents
#' the proportion of times data points i and j were assigned to the same
#' cluster with filtering and normalization applied.
getConsMtx <- function(dat, consMin, n_cores) {
    .Call('_ccImpute_getConsMtx', PACKAGE = 'ccImpute', dat, consMin, n_cores)
}

#' Computes Means and Standard Deviations for Scaling
#' 
#' @param x A numeric matrix representing the gene expression data, where rows
#' are genes and columns are samples.
#' @param n_cores The number of cores to use for parallel processing.
#' @return A list containing:
#'   * `means`: A numeric vector of column means.
#'   * `sds`: A numeric vector of column standard deviations.
getScale <- function(x, n_cores) {
    .Call('_ccImpute_getScale', PACKAGE = 'ccImpute', x, n_cores)
}

#' Computes imputed expression matrix using linear eq solver
#' @param cm processed consensus matrix
#' @param em expression matrix
#' @param ids location of values determined to be dropout events
#' @param n_cores number of cores to use for parallel computation.
#' @return imputed expression matrix
solver <- function(cm, em, ids, n_cores) {
    .Call('_ccImpute_solver', PACKAGE = 'ccImpute', cm, em, ids, n_cores)
}

#' Fast Calculation of "Dropout" values
#' @param cm A numeric matrix representing the consensus matrix.
#' @param em A dense numeric matrix representing the gene expression data,
#' where rows are genes and columns are samples.
#' @param ids An integer matrix specifying the row and column indices of
#' entries for which to calculate importance scores. Each row of `ids` should
#' contain two integers: the row index (gene) and column index (sample) in the
#' `em` matrix.
#' @param n_cores The number of cores to use for parallel processing.
#' @return A numeric vector of imputed dropout values, corresponding to the
#' entries specified in the `ids` matrix.
solver2 <- function(cm, em, ids, n_cores) {
    .Call('_ccImpute_solver2', PACKAGE = 'ccImpute', cm, em, ids, n_cores)
}

#' Fast Calculation of "Dropout" values
#' @param cm A numeric matrix representing the consensus matrix.
#' @param em A sparse numeric matrix representing the gene expression data,
#' where rows are genes and columns are samples.
#' @param ids An integer matrix specifying the row and column indices of
#' entries for which to calculate importance scores. Each row of `ids` should
#' contain two integers: the row index (gene) and column index (sample) in the
#' `em` matrix.
#' @param n_cores The number of cores to use for parallel processing.
#' @return A numeric vector of imputed dropout values, corresponding to the
#' entries specified in the `ids` matrix.
sparseSolver2 <- function(cm, em, ids, n_cores) {
    .Call('_ccImpute_sparseSolver2', PACKAGE = 'ccImpute', cm, em, ids, n_cores)
}

