% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{findDropouts}
\alias{findDropouts}
\title{Identify Dropout Events in Single-Cell Expression Data}
\usage{
findDropouts(logX, consMtx)
}
\arguments{
\item{logX}{A (sparse or dense) numeric matrix representing the transpose of
a log-normalized gene expression matrix. Rows correspond to cells, and 
columns correspond to genes.}

\item{consMtx}{A numeric matrix representing the processed consensus matrix
obtained from clustering analysis.}
}
\value{
A two-column matrix (or data frame) where each row indicates the 
location (row index, column index) of a potential dropout event in the input
matrix `logX`.
}
\description{
Determines which zero values within a transposed, log-normalized expression
matrix are likely dropout events. The identification is based on a weighted
cell voting scheme, where weights are derived from a processed consensus 
matrix.
}
\examples{
library(scater)
library(BiocParallel)
library(splatter)

sce <- splatSimulate(group.prob = rep(1, 5)/5, sparsify = FALSE, 
        batchCells=100, nGenes=1000, method = "groups", verbose = FALSE, 
        dropout.type = "experiment")
sce <- logNormCounts(sce)
cores <- 2
logX <- as.matrix(logcounts(sce))
w <- rowVars_fast(logX, cores)
corMat <- getCorM("spearman", logcounts(sce), w, cores)
v <- doSVD(corMat, nCores=cores)
BPPARAM = MulticoreParam(cores)
consMtx <- runKM(logX, v, BPPARAM=bpparam())
dropIds <- findDropouts(logX, consMtx)

}
