% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scNMF_class.R
\docType{methods}
\name{basis<-,scNMFSet-method}
\alias{basis<-,scNMFSet-method}
\title{Modify basis matrices}
\usage{
\S4method{basis}{scNMFSet}(object) <- value
}
\arguments{
\item{object}{Object of class \code{scNMFSet}}

\item{value}{Basis matrix to be substituted}
}
\value{
Input object with updated basis matrices
}
\description{
Access and modify basis matrices
}
\examples{
set.seed(1)
s <- scNMFSet(count=matrix(rpois(n=12,lambda=3),4,3))
s <- vb_factorize(s, ranks=3)
basis(s)[[1]] <- apply(basis(s)[[1]],c(1,2),round,digits=3)
basis(s)
}
