% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorize.R
\name{factorize}
\alias{factorize}
\title{Maximum likelihood factorization}
\usage{
factorize(object, ranks = 2, nrun = 20, randomize = FALSE,
  nsmpl = 1, verbose = 2, progress.bar = TRUE, Itmax = 10000,
  ncnn.step = 40, criterion = "likelihood", linkage = "average",
  Tol = 1e-05, store.connectivity = FALSE)
}
\arguments{
\item{object}{\code{scNMFSet} object containing count matrix.}

\item{ranks}{Rank for factorization; can be a vector of multiple values.}

\item{nrun}{No. of runs with different initial guess.}

\item{randomize}{Boolean; if \code{TRUE}, input matrix is randomized.}

\item{nsmpl}{No. of randomized samples to average over.}

\item{verbose}{The verbosity level: 
3, each iteration output printed;
2, each run output printed; 
1, each randomized sample output printed;
0, silent.}

\item{progress.bar}{Display progress bar when \code{nrun > 1 } and 
\code{verbose = 1}.}

\item{Itmax}{Maximum no. of iteration.}

\item{ncnn.step}{Minimum no. of steps with no change in connectivity matrix 
to achieve convergence.}

\item{criterion}{If \code{'likelihood'}, iteration stops when fractional 
changes in likelihood is below tolerance \code{Tol}. If 
\code{criterion = 'connectivity'}, iteration stops when connectivity 
matrix does not change for at least \code{ncnn.step} steps.}

\item{linkage}{Method to be sent to \code{hclust} in 
calculating cophenetic correlation.}

\item{Tol}{Tolerance for checking convergence with 
\code{criterion = 'likelihood'}.}

\item{store.connectivity}{Returns a list also containing connectivity data.}
}
\value{
Object of class \code{scNMFSet} with factorization slots filled.
}
\description{
Performs single or multiple rank NMF factorization of count matrix using 
maximum likelihood
}
\details{
The main input is the \code{scNMFSet} object with count matrix.
This function performs non-negative factorization and fills in the empty
slots \code{basis}, \code{coeff}, and \code{ranks}.

When run with multiple values of \code{ranks}, 
        factorization is repeated for each rank and the slot \code{measure} 
        contains quality measures of the ranks. The quality measure 
        \code{likelihood} is negative the KL distance of the fit to the 
        target. With \code{nrun > 1}, the likelihood is the maximum 
        among all runs. 
        
        The quality measure \code{dispersion} is the scalar
        measure of how far the connectivity matrix is from 0, 1. With 
        increasing \code{nrun}, \code{dispersion} decreases from 1. 
        \code{nrun} should be chosen such that \code{dispersion} does not 
        change appreciably.
        With randomization, \code{count} matrix of \code{object} 
        is shuffled. 
        \code{nsmpl} can be used to average over multiple permutations. This 
        averaging applies to each quality measure under a given rank.
}
\examples{
set.seed(1)
x <- simulate_data(nfeatures=10,nsamples=c(20,20,60,40,30))
s <- scNMFSet(count=x)
s <- factorize(s,ranks=seq(2,8),nrun=5)
plot(s)
}
