% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scNMF_class.R
\docType{class}
\name{scNMFSet-class}
\alias{scNMFSet-class}
\alias{plot,scNMFSet,ANY-method}
\title{Class \code{scNMFSet} for storing input data and results}
\usage{
\S4method{plot}{scNMFSet,ANY}(x)
}
\arguments{
\item{x}{Object containing measure}
}
\value{
Object of class \code{scNMFSet}

\code{NULL}
}
\description{
\code{S4} class derived from \code{\link{SingleCellExperiment}}
that can store single-cell count matrix, gene and cell annotation 
data frames, and factorization factors as well as quality measures 
for rank determination.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot measures of an object. 
For quality measures derived from maximum likelihood inference, 
dispersion and cophenetic will be plotted separately.

For measure derived from Bayesian inference, log evidence as a function of 
rank values will be plotted.
}}

\section{Slots}{

\describe{
\item{\code{assays}}{Named list for count matrix \code{counts}.}

\item{\code{rowData}}{\code{DataFrame} for gene (feature) 
names and annotations in columns.}

\item{\code{colData}}{\code{DataFrame} for cell IDs and other 
annotations in columns (e.g., barcodes, cell types).}

\item{\code{ranks}}{Vector for rank values for which factorization has been 
performed.}

\item{\code{basis}}{List (of length equal to that of \code{ranks}) of 
basis matrices \strong{W} from factorization; 
dimension \code{nrow} x \code{rank},
    where \code{nrow} is no. of rows in \code{count}.}

\item{\code{coeff}}{List (of length equal to that of \code{ranks}) of 
coefficient matrices \strong{H} from factorization; 
     dimension \code{rank} x \code{ncol},
     where \code{ncol} is no. of columns in \code{count}.}

\item{\code{measure}}{Data frame of factorization quality measures for 
  each rank (\code{likelihood} and \code{dispersion}).

Other slots inherited from \code{SingleCellExperiment} class are 
not explicitly used.}
}}

\examples{
library(S4Vectors)
# toy matrix
ngenes <- 8 
ncells <- 5
mat <- matrix(rpois(n=ngenes*ncells,lambda=3),ngenes,ncells)

abc <- letters[seq_len(ngenes)]
ABC <- LETTERS[seq_len(ncells)] 
genes <- DataFrame(gene_id=abc)
cells <- DataFrame(cell_id=ABC)
rownames(mat) <- rownames(genes) <- abc
colnames(mat) <- rownames(cells) <- ABC

# create scNMFSet object
s <- scNMFSet(count=mat,rowData=genes,colData=cells)
# alternative ways
s2 <- scNMFSet(count=mat)
s2 <- scNMFSet(assays=list(counts=mat))        

# show dimensions
dim(s)

# show slots
rowData(s)

# modify slots
colData(s) <- DataFrame(cell_id=seq_len(ncells),
              cell_type=c(rep('tissue1',2),
                          rep('tissue2',ncells-2)))
colData(s)
}
