#' @title available models
#' @export
availableModels <- c("celda_C", "celda_G", "celda_CG")


#' A toy count matrix for use with celda.
#'
#' @title sampleCells
#' @description A matrix of simulated gene counts.
#' @format A matrix of simulated gene counts with 10 rows (genes) and 10
#'  columns (cells).
#' @details Generated by Josh Campbell.
#' @source \url{http://github.com/campbio/celda}
"sampleCells"


#' @title celdaCGSim
#' @description An deprecated example of simulated count matrix from the
#'  celda_CG model.
#' @format A list of counts and properties as returned from old simulateCells().
"celdaCGSim"


#' @title celdaCGmod
#' @description celda_CG model object generated from \code{celdaCGSim} using
#'  old \code{celda_CG} function.
#' @format A celda_CG object
# @examples
# data(celdaCGSim)
# celdaCGMod <- celda_CG(celdaCGSim$counts,
#   K = celdaCGSim$K,
#   L = celdaCGSim$L,
#   nchains = 1)
"celdaCGMod"


#' @title celdaCGGridSearchRes
#' @description Example results of old celdaGridSearch on celdaCGSim
#' @format An object as returned from old celdaGridSearch()
# @examples
# data(celdaCGSim)
# celdaCGGridSearchRes <- celdaGridSearch(celdaCGSim$counts,
#   model = "celda_CG",
#   paramsTest = list(K = seq(4, 6), L = seq(9, 11)),
#   paramsFixed = list(sampleLabel = celdaCGSim$sampleLabel),
#   bestOnly = TRUE,
#   nchains = 1,
#   cores = 2)
"celdaCGGridSearchRes"


#' @title celdaCSim
#' @description An old example simulated count matrix from the celda_C model.
#' @format A list of counts and properties as returned from old simulateCells().
# @examples
# celdaCSim <- simulateCells("celda_C")
"celdaCSim"


#' @title celdaCMod
#' @description Old celda_C results generated from celdaCSim
#' @format A celda_C object
# @examples
# data(celdaCSim)
# celdaCMod <- celda_C(celdaCSim$counts, K = celdaCSim$K, nchains = 1)
"celdaCMod"


#' @title celdaGSim
#' @description An old example simulated count matrix from the celda_G model.
#' @format A list of counts and properties as returned from old simulateCells()
# @examples
# celdaGSim <- simulateCells("celda_G")
"celdaGSim"


#' @title celdaGMod
#' @description Old celda_G results generated from celdaGsim
#' @format A celda_G object
# @examples
# data(celdaGSim)
# celdaGMod <- celda_G(celdaGSim$counts, L = celdaGSim$L, nchains = 1)
"celdaGMod"


#' @title contaminationSim
#' @description A toy contamination data generated by
#'  \link{simulateContamination}
#' @format A list
"contaminationSim"


#' @title sceCeldaC
#' @description A \linkS4class{SingleCellExperiment} object containing the
#'  results of running \link{selectFeatures} and \link{celda_C} on
#'  \link{celdaCSim}.
#' @format A \linkS4class{SingleCellExperiment} object
#' @examples
#' data(celdaCSim)
#' sceCeldaC <- selectFeatures(celdaCSim$counts)
#' sceCeldaC <- celda_C(sceCeldaC,
#'     K = celdaCSim$K,
#'     sampleLabel = celdaCSim$sampleLabel,
#'     nchains = 1)
"sceCeldaC"


#' @title sceCeldaG
#' @description A \linkS4class{SingleCellExperiment} object containing the
#'  results of running \link{selectFeatures} and \link{celda_G} on
#'  \link{celdaGSim}.
#' @format A \linkS4class{SingleCellExperiment} object
#' @examples
#' data(celdaGSim)
#' sceCeldaG <- selectFeatures(celdaGSim$counts)
#' sceCeldaG <- celda_G(sceCeldaG, L = celdaGSim$L, nchains = 1)
"sceCeldaG"


#' @title sceCeldaCG
#' @description A \linkS4class{SingleCellExperiment} object containing the
#'  results of running \link{selectFeatures} and \link{celda_CG} on
#'  \link{celdaCGSim}.
#' @format A \linkS4class{SingleCellExperiment} object
#' @examples
#' data(celdaCGSim)
#' sceCeldaCG <- selectFeatures(celdaCGSim$counts)
#' sceCeldaCG <- celda_CG(sceCeldaCG,
#'     K = celdaCGSim$K,
#'     L = celdaCGSim$L,
#'     sampleLabel = celdaCGSim$sampleLabel,
#'     nchains = 1)
"sceCeldaCG"


#' @title sceCeldaCGGridSearch
#' @description A \linkS4class{SingleCellExperiment} object containing the
#'  results of running \link{selectFeatures} and \link{celdaGridSearch} on
#'  \link{celdaCGSim}.
#' @format A \linkS4class{SingleCellExperiment} object
#' @examples
#' data(celdaCGSim)
#' sce <- selectFeatures(celdaCGSim$counts)
#' sceCeldaCGGridSearch <- celdaGridSearch(sce,
#'     model = "celda_CG",
#'     paramsTest = list(K = seq(4, 6), L = seq(9, 11)),
#'     paramsFixed = list(sampleLabel = celdaCGSim$sampleLabel),
#'     bestOnly = TRUE,
#'     nchains = 1,
#'     cores = 1,
#'     verbose = FALSE)
"sceCeldaCGGridSearch"
