% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{celdaClusters}
\alias{celdaClusters}
\alias{celdaClusters,SingleCellExperiment-method}
\alias{celdaClusters,celdaModel-method}
\alias{celdaClusters<-}
\alias{celdaClusters<-,SingleCellExperiment-method}
\title{Get or set the cell cluster labels from a celda
 \linkS4class{SingleCellExperiment} object or celda model
 object.}
\usage{
celdaClusters(x, altExpName = "featureSubset")

\S4method{celdaClusters}{SingleCellExperiment}(x, altExpName = "featureSubset")

\S4method{celdaClusters}{celdaModel}(x)

celdaClusters(x, altExpName = "featureSubset") <- value

\S4method{celdaClusters}{SingleCellExperiment}(x, altExpName = "featureSubset") <- value
}
\arguments{
\item{x}{Can be one of
\itemize{
\item A \linkS4class{SingleCellExperiment} object returned by
\link{celda_C}, or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot. The
a \link{altExp} slot with name \code{altExpName} will
be used. Rows represent features and columns represent cells.
\item Celda model object.}}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{value}{Character vector of cell cluster labels for replacements. Works
only if \code{x} is a \linkS4class{SingleCellExperiment} object.}
}
\value{
One of
\itemize{
 \item Character vector if \code{x} is a
 \linkS4class{SingleCellExperiment} object.
 Contains cell cluster labels for each cell in x.
 \item List if \code{x} is a celda model object. Contains cell cluster
 labels (for celda_C and celdaCG
 Models) and/or feature module labels (for celda_G and celdaCG Models).}
}
\description{
Return or set the cell cluster labels determined
 by \link{celda_C} or \link{celda_CG} models.
}
\examples{
data(sceCeldaCG)
celdaClusters(sceCeldaCG)
data(celdaCGMod)
celdaClusters(celdaCGMod)
}
