% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findMarkersTree.R
\name{plotDendro}
\alias{plotDendro}
\title{Plots dendrogram of \emph{findMarkersTree} output}
\usage{
plotDendro(
  tree,
  classLabel = NULL,
  addSensPrec = FALSE,
  maxFeaturePrint = 4,
  leafSize = 10,
  boxSize = 2,
  boxColor = "black"
)
}
\arguments{
\item{tree}{List object. The output of findMarkersTree()}

\item{classLabel}{A character value. The name of a specific label to draw
the path and rules. If NULL (default), the tree for all clusters is shown.}

\item{addSensPrec}{Logical. Print training sensitivities and precisions
for each cluster below leaf label? Default is FALSE.}

\item{maxFeaturePrint}{Numeric value. Maximum number of markers to print
at a given split. Default is 4.}

\item{leafSize}{Numeric value. Size of text below each leaf. Default is 24.}

\item{boxSize}{Numeric value. Size of rule labels. Default is 7.}

\item{boxColor}{Character value. Color of rule labels. Default is black.}
}
\value{
A ggplot2 object
}
\description{
Generates a dendrogram of the rules and performance
(optional) of the decision tree generated by findMarkersTree().
}
\examples{
# Generate simulated single-cell dataset using celda 
sce <- celda::simulateCells("celda_CG", K = 4, L = 10, G = 100)

# Select top features
sce <- selectFeatures(sce)

# Celda clustering into 5 clusters & 10 modules
sce <- celda_CG(sce, K=5, L=10, verbose=FALSE)

# Get features matrix and cluster assignments
factorizedCounts <- factorizeMatrix(sce, type = "counts")
featureMatrix <- factorizedCounts$counts$cell
classes <- as.integer(celdaClusters(sce))

# Generate Decision Tree
DecTree <- findMarkersTree(featureMatrix, classes)

# Plot dendrogram
plotDendro(DecTree)

}
