% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dr.R
\name{plotDimReduceModule}
\alias{plotDimReduceModule}
\alias{plotDimReduceModule,SingleCellExperiment-method}
\alias{plotDimReduceModule,ANY-method}
\title{Plotting Celda module probability on a
 dimension reduction plot}
\usage{
plotDimReduceModule(
  x,
  reducedDimName,
  useAssay = "counts",
  altExpName = "featureSubset",
  celdaMod,
  modules = NULL,
  dim1 = NULL,
  dim2 = NULL,
  size = 0.5,
  xlab = NULL,
  ylab = NULL,
  rescale = TRUE,
  limits = c(0, 1),
  colorLow = "grey90",
  colorHigh = "firebrick1",
  ncol = NULL,
  decreasing = FALSE
)

\S4method{plotDimReduceModule}{SingleCellExperiment}(
  x,
  reducedDimName,
  useAssay = "counts",
  altExpName = "featureSubset",
  modules = NULL,
  dim1 = 1,
  dim2 = 2,
  size = 0.5,
  xlab = NULL,
  ylab = NULL,
  rescale = TRUE,
  limits = c(0, 1),
  colorLow = "grey90",
  colorHigh = "firebrick1",
  ncol = NULL,
  decreasing = FALSE
)

\S4method{plotDimReduceModule}{ANY}(
  x,
  celdaMod,
  modules = NULL,
  dim1,
  dim2,
  size = 0.5,
  xlab = "Dimension_1",
  ylab = "Dimension_2",
  rescale = TRUE,
  limits = c(0, 1),
  colorLow = "grey90",
  colorHigh = "firebrick1",
  ncol = NULL,
  decreasing = FALSE
)
}
\arguments{
\item{x}{Numeric matrix or a \linkS4class{SingleCellExperiment} object
with the matrix located in the assay slot under \code{useAssay}. Rows
represent features and columns represent cells.}

\item{reducedDimName}{The name of the dimension reduction slot in
\code{reducedDimNames(x)} if \code{x} is a
\linkS4class{SingleCellExperiment} object. Ignored if both \code{dim1} and
\code{dim2} are set.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a
\linkS4class{SingleCellExperiment} object. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{celdaMod}{Celda object of class "celda_G" or "celda_CG". Used only if
\code{x} is a matrix object.}

\item{modules}{Character vector. Module(s) from celda model to be plotted.
e.g. c("1", "2").}

\item{dim1}{Integer or numeric vector. If \code{reducedDimName} is supplied,
then, this will be used as an index to determine which dimension will be
plotted on the x-axis. If \code{reducedDimName} is not supplied, then this
should be a vector which will be plotted on the x-axis. Default \code{1}.}

\item{dim2}{Integer or numeric vector. If \code{reducedDimName} is supplied,
then, this will be used as an index to determine which dimension will be
plotted on the y-axis. If \code{reducedDimName} is not supplied, then this
should be a vector which will be plotted on the y-axis. Default \code{2}.}

\item{size}{Numeric. Sets size of point on plot. Default 0.5.}

\item{xlab}{Character vector. Label for the x-axis. Default "Dimension_1".}

\item{ylab}{Character vector. Label for the y-axis. Default "Dimension_2".}

\item{rescale}{Logical.
Whether rows of the matrix should be rescaled to [0, 1]. Default TRUE.}

\item{limits}{Passed to \link{scale_colour_gradient}. The range
of color scale.}

\item{colorLow}{Character. A color available from `colors()`.
The color will be used to signify the lowest values on the scale.}

\item{colorHigh}{Character. A color available from `colors()`.
The color will be used to signify the highest values on the scale.}

\item{ncol}{Integer. Passed to \link[ggplot2]{facet_wrap}. Specify the
number of columns for facet wrap.}

\item{decreasing}{logical. Specifies the order of plotting the points.
If \code{FALSE}, the points will be plotted in increasing order where
the points with largest values will be on top. \code{TRUE} otherwise.
If \code{NULL}, no sorting is performed. Points will be plotted in their
current order in \code{x}. Default \code{FALSE}.}
}
\value{
The plot as a ggplot object
}
\description{
Create a scatterplot for each row of a normalized
 gene expression matrix where x and y axis are from a data
 dimension reduction tool.
 The cells are colored by the module probability.
}
\examples{
data(sceCeldaCG)
sce <- celdaTsne(sceCeldaCG)
plotDimReduceModule(x = sce,
  reducedDimName = "celda_tSNE",
  modules = c("1", "2"))
library(SingleCellExperiment)
data(sceCeldaCG, celdaCGMod)
sce <- celdaTsne(sceCeldaCG)
plotDimReduceModule(x = counts(sce),
  dim1 = reducedDim(altExp(sce), "celda_tSNE")[, 1],
  dim2 = reducedDim(altExp(sce), "celda_tSNE")[, 2],
  celdaMod = celdaCGMod,
  modules = c("1", "2"))
}
