% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{reportceldaCG}
\alias{reportceldaCG}
\alias{reportCeldaCGRun}
\alias{reportCeldaCGPlotResults}
\title{Generate an HTML report for celda_CG}
\usage{
reportCeldaCGRun(
  sce,
  L,
  K,
  sampleLabel = NULL,
  altExpName = "featureSubset",
  useAssay = "counts",
  initialL = 10,
  maxL = 150,
  initialK = 5,
  maxK = 50,
  minCell = 3,
  minCount = 3,
  maxFeatures = 5000,
  output_file = "CeldaCG_RunReport",
  output_sce_prefix = "celda_cg",
  output_dir = ".",
  pdf = FALSE,
  showSession = TRUE
)

reportCeldaCGPlotResults(
  sce,
  reducedDimName,
  features = NULL,
  displayName = NULL,
  altExpName = "featureSubset",
  useAssay = "counts",
  cellAnnot = NULL,
  cellAnnotLabel = NULL,
  exactMatch = TRUE,
  moduleFilePrefix = "module_features",
  output_file = "CeldaCG_ResultReport",
  output_dir = ".",
  pdf = FALSE,
  showSetup = TRUE,
  showSession = TRUE
)
}
\arguments{
\item{sce}{A \linkS4class{SingleCellExperiment} with the matrix located in
the assay slot under \code{useAssay}. Rows represent features and columns
represent cells.}

\item{L}{Integer. Final number of feature modules. See \code{celda_CG} for
more information.}

\item{K}{Integer. Final number of cell populations. See \code{celda_CG} for
more information.}

\item{sampleLabel}{Vector or factor. Denotes the sample label for each cell
(column) in the count matrix.}

\item{altExpName}{The name for the \link{altExp} slot to use. Default
\code{"featureSubset"}.}

\item{useAssay}{A string specifying which \link{assay} slot to use. Default
\code{"counts"}.}

\item{initialL}{Integer. Minimum number of modules to try. See
\link{recursiveSplitModule} for more information. Defailt \code{10}.}

\item{maxL}{Integer. Maximum number of modules to try. See
\link{recursiveSplitModule} for more information. Default \code{150}.}

\item{initialK}{Integer. Initial number of cell populations to try.}

\item{maxK}{Integer. Maximum number of cell populations to try.}

\item{minCell}{Integer. Minimum number of cells required for feature
selection. See \link{selectFeatures} for more information. Default
\code{3}.}

\item{minCount}{Integer. Minimum number of counts required for feature
selection. See \link{selectFeatures} for more information. Default
\code{3}.}

\item{maxFeatures}{Integer. Maximum number of features to include. If the
number of features after filtering for \code{minCell} and \code{minCount}
are greater than \code{maxFeature}, then Seurat's VST function is used to
select the top variable features. Default \code{5000}.}

\item{output_file}{Character. Prefix of the html file. Default
\code{"CeldaCG_ResultReport"}.}

\item{output_sce_prefix}{Character. The \code{sce} object with
\code{celda_CG} results will be saved to an \code{.rds} file starting with
this prefix. Default \code{celda_cg}.}

\item{output_dir}{Character. Path to save the html file. Default \code{.}.}

\item{pdf}{Boolean. Whether to create PDF versions of each plot in addition
to PNGs. Default \code{FALSE}.}

\item{showSession}{Boolean. Whether to show the session information at the
end. Default \code{TRUE}.}

\item{reducedDimName}{Character. Name of the reduced dimensional object to be
used in 2-D scatter plots throughout the report. Default \code{celda_UMAP}.}

\item{features}{Character vector.  Expression of these features will be
displayed on a reduced dimensional plot defined by \code{reducedDimName}.
If \code{NULL}, then no plotting of features on a reduced dimensinoal plot
will be performed. Default \code{NULL}.}

\item{displayName}{Character. The name to use for display in scatter plots
and heatmaps. If \code{NULL}, then the rownames of the \code{sce} object
will be used. This can also be set to the name of a column in the row data
of \code{sce} or \code{altExp(sce, altExpName)}. Default \code{NULL}.}

\item{cellAnnot}{Character vector. The cell-level annotations to display on
the reduced dimensional plot. These variables should be present in the
column data of the \code{sce} object. Default \code{NULL}.}

\item{cellAnnotLabel}{Character vector. Additional cell-level annotations
to display on the reduced dimensional plot. Variables will be treated
as categorial and labels for each group will be placed on the plot.
These variables should be present in the column data of the \code{sce}
object. Default \code{NULL}.}

\item{exactMatch}{Boolean. Whether to only identify exact matches or to
identify partial matches using \code{\link{grep}}. Default \code{FALSE}.}

\item{moduleFilePrefix}{Character. The features in each module will be
written to a a csv file starting with this name. If \code{NULL}, then no
file will be written. Default \code{"module_features"}.}

\item{showSetup}{Boolean. Whether to show the setup code at the beginning.
Default \code{TRUE}.}
}
\value{
.html file
}
\description{
\code{reportCeldaCGRun} will run \link{recursiveSplitModule} and
  \link{recursiveSplitCell} to find the number of modules (\code{L}) and the
  number of cell populations (\code{K}). A final \link{celda_CG} model will
  be selected from \link{recursiveSplitCell}. After a \link{celda_CG} model
  has been fit, \code{reportCeldaCGPlotResults} can be used to create an HTML
  report for visualization and exploration of the \link{celda_CG} model
  results. Some of the plotting and feature selection functions require the
  installation of the Bioconductor package \code{singleCellTK}.
}
\examples{
data(sceCeldaCG)
\dontrun{
library(SingleCellExperiment)
sceCeldaCG$sum <- colSums(counts(sceCeldaCG))
rowData(sceCeldaCG)$rownames <- rownames(sceCeldaCG)
sceCeldaCG <- reportCeldaCGRun(sceCeldaCG,
    initialL = 5, maxL = 20, initialK = 5,
    maxK = 20, L = 10, K = 5)
reportCeldaCGPlotResults(sce = sceCeldaCG,
    reducedDimName = "celda_UMAP",
    features = c("Gene_1", "Gene_100"),
    displayName = "rownames",
    cellAnnot="sum")
}
}
