% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{sampleLabel}
\alias{sampleLabel}
\alias{sampleLabel,SingleCellExperiment-method}
\alias{sampleLabel<-}
\alias{sampleLabel<-,SingleCellExperiment-method}
\alias{sampleLabel,celdaModel-method}
\title{Get or set sample labels from a celda
 \linkS4class{SingleCellExperiment}  object}
\usage{
sampleLabel(x, altExpName = "featureSubset")

\S4method{sampleLabel}{SingleCellExperiment}(x, altExpName = "featureSubset")

sampleLabel(x, altExpName = "featureSubset") <- value

\S4method{sampleLabel}{SingleCellExperiment}(x, altExpName = "featureSubset") <- value

\S4method{sampleLabel}{celdaModel}(x)
}
\arguments{
\item{x}{Can be one of
\itemize{
\item A \linkS4class{SingleCellExperiment} object returned by
\link{celda_C}, \link{celda_G}, or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot.
Rows represent features and columns represent cells.
\item A celda model object.}}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{value}{Character vector of sample labels for replacements. Works
only is \code{x} is a \linkS4class{SingleCellExperiment} object.}
}
\value{
Character vector. Contains the sample labels provided at model
 creation, or those automatically generated by celda.
}
\description{
Return or set the sample labels for the cells in \code{sce}.
}
\examples{
data(sceCeldaCG)
sampleLabel(sceCeldaCG)
data(celdaCGMod)
sampleLabel(celdaCGMod)
}
