% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celdaGridSearch.R
\name{selectBestModel}
\alias{selectBestModel}
\alias{selectBestModel,SingleCellExperiment-method}
\alias{selectBestModel,celdaList-method}
\title{Select best chain within each combination of parameters}
\usage{
selectBestModel(x, asList = FALSE, altExpName = "featureSubset")

\S4method{selectBestModel}{SingleCellExperiment}(x, asList = FALSE, altExpName = "featureSubset")

\S4method{selectBestModel}{celdaList}(x, asList = FALSE)
}
\arguments{
\item{x}{Can be one of
\itemize{
 \item A \linkS4class{SingleCellExperiment} object returned from
 \code{celdaGridSearch}, \code{recursiveSplitModule},
 or \code{recursiveSplitCell}. Must contain a list named
 \code{"celda_grid_search"} in \code{metadata(x)}.
 \item celdaList object.}}

\item{asList}{\code{TRUE} or \code{FALSE}. Whether to return the
best model as a
\code{celdaList} object or not. If \code{FALSE}, return the best model as a
corresponding celda model object.}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
One of
\itemize{
 \item A new \linkS4class{SingleCellExperiment} object containing
 one model with the best log-likelihood for each set of parameters in
 \code{metadata(x)}. If there is only one set of parameters,
 a new \linkS4class{SingleCellExperiment} object
 with the matching model stored in the
 \link{metadata}
 \code{"celda_parameters"} slot will be returned. Otherwise, a new
 \linkS4class{SingleCellExperiment} object with the subset models stored
 in the \link{metadata}
 \code{"celda_grid_search"} slot will be returned.
 \item A new \code{celdaList} object containing one model with the best
 log-likelihood for each set of parameters. If only one set of parameters
 is in the \code{celdaList}, the best model will be returned directly
 instead of a \code{celdaList} object.}
}
\description{
Select the chain with the best log likelihood for each
 combination of tested parameters from a \code{SCE} object gererated by
 \link{celdaGridSearch} or from a \code{celdaList} object.
}
\examples{
data(sceCeldaCGGridSearch)
## Returns same result as running celdaGridSearch with "bestOnly = TRUE"
sce <- selectBestModel(sceCeldaCGGridSearch)
data(celdaCGGridSearchRes)
## Returns same result as running celdaGridSearch with "bestOnly = TRUE"
cgsBest <- selectBestModel(celdaCGGridSearchRes)
}
\seealso{
\link{celdaGridSearch} \link{subsetCeldaList}
}
