% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeatures.R
\name{selectFeatures}
\alias{selectFeatures}
\alias{selectFeatures,SingleCellExperiment-method}
\alias{selectFeatures,matrix-method}
\title{Simple feature selection by feature counts}
\usage{
selectFeatures(
  x,
  minCount = 3,
  minCell = 3,
  useAssay = "counts",
  altExpName = "featureSubset"
)

\S4method{selectFeatures}{SingleCellExperiment}(
  x,
  minCount = 3,
  minCell = 3,
  useAssay = "counts",
  altExpName = "featureSubset"
)

\S4method{selectFeatures}{matrix}(
  x,
  minCount = 3,
  minCell = 3,
  useAssay = "counts",
  altExpName = "featureSubset"
)
}
\arguments{
\item{x}{A numeric \link{matrix} of counts or a
\linkS4class{SingleCellExperiment}
with the matrix located in the assay slot under \code{useAssay}.
Rows represent features and columns represent cells.}

\item{minCount}{Minimum number of counts required for feature selection.}

\item{minCell}{Minimum number of cells required for feature selection.}

\item{useAssay}{A string specifying the name of the
\link{assay} slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
A \linkS4class{SingleCellExperiment} object with a
 \code{altExpName} \link{altExp} slot. Function
 parameter settings are stored in the \link{metadata}
 \code{"select_features"} slot.
}
\description{
A simple heuristic feature selection procedure.
 Select features with at least \code{minCount} counts
 in at least \code{minCell} cells. A \linkS4class{SingleCellExperiment}
 object with subset features will be stored in the
 \link{altExp} slot with name \code{altExpName}.
 The name of the \code{assay} slot in \link{altExp}
 will be the same as \code{useAssay}.
}
\examples{
data(sceCeldaCG)
sce <- selectFeatures(sceCeldaCG)
data(celdaCGSim)
sce <- selectFeatures(celdaCGSim$counts)
}
