% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotateVcf-methods.R
\name{AnnotateVcf,CellBaseR-method}
\alias{AnnotateVcf,CellBaseR-method}
\alias{AnnotateVcf}
\title{AnnotateVcf}
\usage{
\S4method{AnnotateVcf}{CellBaseR}(object, file, batch_size, num_threads, BPPARAM = bpparam())
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{file}{Path to a bgzipped and tabix indexed vcf file}

\item{batch_size}{intger if multiple queries are raised by a single method 
call, e.g. getting annotation info for several genes,
queries will be sent to the server in batches. This slot indicates the size 
of each batch, e.g. 200}

\item{num_threads}{number of asynchronus batches to be sent to the server}

\item{BPPARAM}{a BiocParallel class object}
}
\value{
a dataframe with the results of the query
}
\description{
This method is a convience method to annotate bgzipped tabix-indexed vcf 
files. It should be ideal for annotating small to medium sized 
vcf files.
}
\examples{
cb <- CellBaseR()
fl <- system.file("extdata", "hapmap_exome_chr22_200.vcf.gz",
                  package = "cellbaseR" )
res <- AnnotateVcf(object=cb, file=fl, BPPARAM = bpparam(workers=2),batch_size=100)
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
