% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bam_insert_metrics.R
\name{read_bam_insert_metrics}
\alias{read_bam_insert_metrics}
\title{Calculate insert sizes from a curated GRanges object}
\usage{
read_bam_insert_metrics(
  bamfile,
  chromosome_to_keep = paste0("chr", 1:22),
  strand_mode = 1,
  genome_label = "hg19",
  outdir = NA,
  isize_min = 1L,
  isize_max = 1000L,
  ...
)
}
\arguments{
\item{bamfile}{The bam file name.}

\item{chromosome_to_keep}{Should be a character vector containing the 
seqnames to be kept in the GRanges object. 
Default is paste0("chr", 1:22).}

\item{strand_mode}{Usually the strand_mode  = 1 means the First read is 
aligned to positive strand. Details please see GenomicAlignments docs.}

\item{genome_label}{The Genome you used in the alignment. 
Should be "hg19" or "hg38" or "hg38-NCBI. Default is "hg19". 
Note: "hg19" will load BSgenome.Hsapiens.UCSC.hg19 package, which is 
Full genome sequences for Homo sapiens (Human) as provided by 
UCSC (hg19, based on GRCh37.p13) and stored in Biostrings objects; 
"hg38" will load BSgenome.Hsapiens.UCSC.hg38 package, which is 
Full genome sequences for Homo sapiens (Human) as provided by 
UCSC (hg38, based on GRCh38.p13) and stored in Biostrings objects.
"hg38-NCBI" will load BSgenome.Hsapiens.NCBI.GRCh38 package, which is 
full genome sequences for Homo sapiens (Human) as provided by 
NCBI (GRCh38, 2013-12-17) and stored in Biostrings objects.}

\item{outdir}{The path for saving rds file. Default is NA, i.e. not saving.}

\item{isize_min}{min fragment length to keep, default is 1L.}

\item{isize_max}{max fragment length to keep, default is 1000L.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
This function returns a dataframe with two columns: "insert_size" 
   and "All_Reads.fr_count".
}
\description{
Calculate insert sizes from a curated GRanges object
}
\examples{
\dontrun{

object <- read_bam_insert_metrics(bamfile = "/path/to/bamfile.bam")
}

}
\author{
Haichao Wang
}
