% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_colData_on_embedding}
\alias{plot_colData_on_embedding}
\title{Plot Metadata Variables}
\usage{
plot_colData_on_embedding(
  object,
  group = "batch",
  embedding = "UMAP",
  dims = c(1, 2),
  highlight = NULL,
  return_plotly = FALSE,
  ...
)
}
\arguments{
\item{object}{A SingleCellExperiment object}

\item{group}{Name of one or more metadata columns to group (color) cells by}

\item{embedding}{The dimensional reduction technique to be used}

\item{dims}{Dimensions to plot, must be a two-length numeric vector}

\item{highlight}{A list of vectors of cells to highlight}

\item{return_plotly}{Convert plot to interactive web-based graph}

\item{...}{extra parameters passed to ggplot}
}
\value{
a ggplot
}
\description{
Plots static or interactive plot where each point represents a cell metadata
variable whose position on the map depends on cell embeddings
determined by the reduction technique used
}
\examples{

data(small_example_dataset)

# static mode
plot_colData_on_embedding(small_example_dataset, "Mutation_Status", return_plotly = FALSE)
}
