% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiggleplotr.R
\name{plot_gene_coverage_by_var}
\alias{plot_gene_coverage_by_var}
\title{Plot BigWig Coverage for Genes of Interest by a Given Variable}
\usage{
plot_gene_coverage_by_var(
  genes_of_interest = "NRL",
  cell_metadata,
  bigwig_tbl,
  group_by = "batch",
  values_of_interest = NULL,
  organism = c("human", "mouse"),
  edb = NULL,
  heights = c(3, 1),
  scale_y = "log10",
  reverse_x = FALSE,
  start = NULL,
  end = NULL,
  summarize_transcripts = FALSE,
  ...
)
}
\arguments{
\item{genes_of_interest}{Gene of interest}

\item{cell_metadata}{a dataframe with cell metadata from object}

\item{bigwig_tbl}{a tibble with colnames "name", "bigWig", and "sample_id"
matching the filename, absolute path, and sample name of each cell in the
cell_metadata}

\item{group_by}{Variable to color by}

\item{values_of_interest}{values of interest}

\item{organism}{human (default) or mouse}

\item{edb}{ensembldb object}

\item{heights}{The heights of each row in the grid of plot}

\item{scale_y}{whether to scale coverage}

\item{reverse_x}{whether to reverse x axis}

\item{start}{start coordinates}

\item{end}{end coordinates}

\item{summarize_transcripts}{whether to summarize transcript counts}

\item{...}{extra arguments passed to plotCoverageFromEnsembldb}
}
\value{
a ggplot with coverage faceted by group_by
}
\description{
Plot BigWig coverage for genes of interest colored by a given variable
}
